/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.hiscore;

import java.util.Set;
import lombok.Generated;
import net.runelite.api.WorldType;
import okhttp3.HttpUrl;

public enum HiscoreEndpoint {
    NORMAL("Normal", "http://65.49.60.205:9293?mode=normal"),
    IRONMAN("Ironman", "http://65.49.60.205:9293?mode=ironman"),
    HARDCORE_IRONMAN("Hardcore Ironman", "http://65.49.60.205:9293?mode=hardcore_ironman"),
    ULTIMATE_IRONMAN("Ultimate Ironman", "http://65.49.60.205:9293?mode=ultimate_ironman"),
    DEADMAN("Deadman", "http://65.49.60.205:9293?mode=deadman"),
    LEAGUE("Leagues", "http://65.49.60.205:9293?mode=seasonal"),
    TOURNAMENT("Tournament", "http://65.49.60.205:9293?mode=tournament"),
    FRESH_START_WORLD("Fresh Start", "http://65.49.60.205:9293?mode=fresh_start"),
    PURE("1 Defence Pure", "http://65.49.60.205:9293?mode=skiller_defence"),
    LEVEL_3_SKILLER("Level 3 Skiller", "http://65.49.60.205:9293?mode=skiller");

    private final String name;
    private final HttpUrl hiscoreURL;

    private HiscoreEndpoint(String name, String hiscoreURL) {
        this.name = name;
        this.hiscoreURL = HttpUrl.get(hiscoreURL);
    }

    public static HiscoreEndpoint fromWorldTypes(Set<WorldType> worldTypes) {
        if (worldTypes.contains((Object)WorldType.SEASONAL)) {
            return LEAGUE;
        }
        if (worldTypes.contains((Object)WorldType.TOURNAMENT_WORLD)) {
            return TOURNAMENT;
        }
        if (worldTypes.contains((Object)WorldType.DEADMAN)) {
            return DEADMAN;
        }
        if (worldTypes.contains((Object)WorldType.FRESH_START_WORLD)) {
            return FRESH_START_WORLD;
        }
        return NORMAL;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public HttpUrl getHiscoreURL() {
        return this.hiscoreURL;
    }
}

