/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.agility;

import com.google.common.collect.EvictingQueue;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.plugins.agility.Courses;
import net.runelite.client.plugins.xptracker.XpTrackerService;

class AgilitySession {
    private final Courses course;
    private Instant lastLapCompleted;
    private int totalLaps;
    private int lapsTillGoal;
    private final EvictingQueue<Duration> lastLapTimes = EvictingQueue.create(30);
    private int lapsPerHour;

    AgilitySession(Courses course) {
        this.course = course;
    }

    void incrementLapCount(Client client2, XpTrackerService xpTrackerService) {
        this.calculateLapsPerHour();
        ++this.totalLaps;
        int currentExp = client2.getSkillExperience(Skill.AGILITY);
        int goalXp = xpTrackerService.getEndGoalXp(Skill.AGILITY);
        int goalRemainingXp = goalXp - currentExp;
        double courseTotalExp = this.course.getTotalXp();
        if (this.course == Courses.PYRAMID) {
            courseTotalExp += (double)Math.min(300 + 8 * client2.getRealSkillLevel(Skill.AGILITY), 1000);
        }
        this.lapsTillGoal = goalRemainingXp > 0 ? (int)Math.ceil((double)goalRemainingXp / courseTotalExp) : 0;
    }

    void calculateLapsPerHour() {
        Duration timeSinceLastLap;
        Instant now = Instant.now();
        if (this.lastLapCompleted != null && !(timeSinceLastLap = Duration.between(this.lastLapCompleted, now)).isNegative()) {
            this.lastLapTimes.add(timeSinceLastLap);
            Duration sum = Duration.ZERO;
            for (Duration lapTime : this.lastLapTimes) {
                sum = sum.plus(lapTime);
            }
            Duration averageLapTime = sum.dividedBy(this.lastLapTimes.size());
            this.lapsPerHour = (int)(Duration.ofHours(1L).toMillis() / averageLapTime.toMillis());
        }
        this.lastLapCompleted = now;
    }

    @Generated
    public Courses getCourse() {
        return this.course;
    }

    @Generated
    public Instant getLastLapCompleted() {
        return this.lastLapCompleted;
    }

    @Generated
    public int getTotalLaps() {
        return this.totalLaps;
    }

    @Generated
    public int getLapsTillGoal() {
        return this.lapsTillGoal;
    }

    @Generated
    public EvictingQueue<Duration> getLastLapTimes() {
        return this.lastLapTimes;
    }

    @Generated
    public int getLapsPerHour() {
        return this.lapsPerHour;
    }

    @Generated
    public void setLastLapCompleted(Instant lastLapCompleted) {
        this.lastLapCompleted = lastLapCompleted;
    }

    @Generated
    public void setTotalLaps(int totalLaps) {
        this.totalLaps = totalLaps;
    }

    @Generated
    public void setLapsTillGoal(int lapsTillGoal) {
        this.lapsTillGoal = lapsTillGoal;
    }

    @Generated
    public void setLapsPerHour(int lapsPerHour) {
        this.lapsPerHour = lapsPerHour;
    }
}

