/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grandexchange;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.ge.GrandExchangeTrade;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrandExchangeClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrandExchangeClient.class);
    private final OkHttpClient client;
    private final HttpUrl apiBase;
    private final Gson gson;
    private UUID uuid;
    private String machineId;

    @Inject
    GrandExchangeClient(OkHttpClient client2, @Named(value="runelite.api.base") HttpUrl apiBase, Gson gson) {
        this.client = client2;
        this.apiBase = apiBase;
        this.gson = gson;
    }

    public void submit(GrandExchangeTrade grandExchangeTrade) {
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("ge").build();
        Request.Builder builder = new Request.Builder();
        if (this.uuid != null) {
            builder.header("RUNELITE-AUTH", this.uuid.toString());
        }
        if (this.machineId != null) {
            builder.header("RUNELITE-MACHINEID", this.machineId);
        }
        Request request = builder.post(RequestBody.create(RuneLiteAPI.JSON, this.gson.toJson(grandExchangeTrade))).url(url).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                log.debug("unable to submit trade", e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                log.debug("Submitted trade");
                response.close();
            }
        });
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }
}

