/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import lombok.Generated;
import net.runelite.client.plugins.raids.RaidRoom;

public enum RoomType {
    START("Start", '#'),
    END("End", '\u00a4'),
    SCAVENGERS("Scavengers", 'S'),
    FARMING("Farming", 'F'),
    EMPTY("Empty", ' '),
    COMBAT("Combat", 'C'),
    PUZZLE("Puzzle", 'P');

    private final String name;
    private final char code;

    RaidRoom getUnsolvedRoom() {
        switch (this.ordinal()) {
            case 0: {
                return RaidRoom.START;
            }
            case 1: {
                return RaidRoom.END;
            }
            case 2: {
                return RaidRoom.SCAVENGERS;
            }
            case 3: {
                return RaidRoom.FARMING;
            }
            case 5: {
                return RaidRoom.UNKNOWN_COMBAT;
            }
            case 6: {
                return RaidRoom.UNKNOWN_PUZZLE;
            }
        }
        return RaidRoom.EMPTY;
    }

    static RoomType fromCode(char code) {
        for (RoomType type : RoomType.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return EMPTY;
    }

    @Generated
    private RoomType(String name, char code) {
        this.name = name;
        this.code = code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public char getCode() {
        return this.code;
    }
}

