/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.components;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import lombok.Generated;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class SplitComponent
implements LayoutableRenderableEntity {
    private LayoutableRenderableEntity first;
    private LayoutableRenderableEntity second;
    private Point preferredLocation;
    private Dimension preferredSize;
    private ComponentOrientation orientation;
    private Point gap;
    private final Rectangle bounds;

    @Override
    public Dimension render(Graphics2D graphics) {
        int totalHeight;
        int totalWidth;
        this.first.setPreferredLocation(this.preferredLocation);
        this.first.setPreferredSize(this.preferredSize);
        Dimension firstDimension = this.first.render(graphics);
        int x = 0;
        int y = 0;
        if (this.orientation == ComponentOrientation.VERTICAL) {
            y = firstDimension.height + this.gap.y;
        } else {
            x = firstDimension.width + this.gap.x;
        }
        this.second.setPreferredLocation(new Point(x + this.preferredLocation.x, y + this.preferredLocation.y));
        this.second.setPreferredSize(new Dimension(this.preferredSize.width - x, this.preferredSize.height - y));
        Dimension secondDimension = this.second.render(graphics);
        if (this.orientation == ComponentOrientation.VERTICAL) {
            totalWidth = Math.max(firstDimension.width, secondDimension.width);
            totalHeight = y + secondDimension.height;
        } else {
            totalHeight = Math.max(firstDimension.height, secondDimension.height);
            totalWidth = x + secondDimension.width;
        }
        Dimension dimension = new Dimension(totalWidth, totalHeight);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    @Generated
    private static Point $default$preferredLocation() {
        return new Point();
    }

    @Generated
    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    @Generated
    private static ComponentOrientation $default$orientation() {
        return ComponentOrientation.VERTICAL;
    }

    @Generated
    private static Point $default$gap() {
        return new Point(0, 0);
    }

    @Generated
    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    @Generated
    SplitComponent(LayoutableRenderableEntity first, LayoutableRenderableEntity second, Point preferredLocation, Dimension preferredSize, ComponentOrientation orientation, Point gap, Rectangle bounds) {
        this.first = first;
        this.second = second;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.orientation = orientation;
        this.gap = gap;
        this.bounds = bounds;
    }

    @Generated
    public static SplitComponentBuilder builder() {
        return new SplitComponentBuilder();
    }

    @Generated
    public void setFirst(LayoutableRenderableEntity first) {
        this.first = first;
    }

    @Generated
    public void setSecond(LayoutableRenderableEntity second) {
        this.second = second;
    }

    @Override
    @Generated
    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    @Override
    @Generated
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Generated
    public void setOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    @Generated
    public void setGap(Point gap) {
        this.gap = gap;
    }

    @Override
    @Generated
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Generated
    public static class SplitComponentBuilder {
        @Generated
        private LayoutableRenderableEntity first;
        @Generated
        private LayoutableRenderableEntity second;
        @Generated
        private boolean preferredLocation$set;
        @Generated
        private Point preferredLocation$value;
        @Generated
        private boolean preferredSize$set;
        @Generated
        private Dimension preferredSize$value;
        @Generated
        private boolean orientation$set;
        @Generated
        private ComponentOrientation orientation$value;
        @Generated
        private boolean gap$set;
        @Generated
        private Point gap$value;
        @Generated
        private boolean bounds$set;
        @Generated
        private Rectangle bounds$value;

        @Generated
        SplitComponentBuilder() {
        }

        @Generated
        public SplitComponentBuilder first(LayoutableRenderableEntity first) {
            this.first = first;
            return this;
        }

        @Generated
        public SplitComponentBuilder second(LayoutableRenderableEntity second) {
            this.second = second;
            return this;
        }

        @Generated
        public SplitComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation$value = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        @Generated
        public SplitComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize$value = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        @Generated
        public SplitComponentBuilder orientation(ComponentOrientation orientation) {
            this.orientation$value = orientation;
            this.orientation$set = true;
            return this;
        }

        @Generated
        public SplitComponentBuilder gap(Point gap) {
            this.gap$value = gap;
            this.gap$set = true;
            return this;
        }

        @Generated
        public SplitComponentBuilder bounds(Rectangle bounds) {
            this.bounds$value = bounds;
            this.bounds$set = true;
            return this;
        }

        @Generated
        public SplitComponent build() {
            Point preferredLocation$value = this.preferredLocation$value;
            if (!this.preferredLocation$set) {
                preferredLocation$value = SplitComponent.$default$preferredLocation();
            }
            Dimension preferredSize$value = this.preferredSize$value;
            if (!this.preferredSize$set) {
                preferredSize$value = SplitComponent.$default$preferredSize();
            }
            ComponentOrientation orientation$value = this.orientation$value;
            if (!this.orientation$set) {
                orientation$value = SplitComponent.$default$orientation();
            }
            Point gap$value = this.gap$value;
            if (!this.gap$set) {
                gap$value = SplitComponent.$default$gap();
            }
            Rectangle bounds$value = this.bounds$value;
            if (!this.bounds$set) {
                bounds$value = SplitComponent.$default$bounds();
            }
            return new SplitComponent(this.first, this.second, preferredLocation$value, preferredSize$value, orientation$value, gap$value, bounds$value);
        }

        @Generated
        public String toString() {
            return "SplitComponent.SplitComponentBuilder(first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", preferredLocation$value=" + String.valueOf(this.preferredLocation$value) + ", preferredSize$value=" + String.valueOf(this.preferredSize$value) + ", orientation$value=" + String.valueOf((Object)this.orientation$value) + ", gap$value=" + String.valueOf(this.gap$value) + ", bounds$value=" + String.valueOf(this.bounds$value) + ")";
        }
    }
}

