/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScreenDeviceRefreshRateHelper
extends Enum<ScreenDeviceRefreshRateHelper> {
    private static final Logger logger;
    public static final int DEFAULT_REFRESH_RATE = 60;
    private static final /* synthetic */ ScreenDeviceRefreshRateHelper[] $VALUES;

    public static ScreenDeviceRefreshRateHelper[] values() {
        return (ScreenDeviceRefreshRateHelper[])$VALUES.clone();
    }

    public static ScreenDeviceRefreshRateHelper valueOf(String name) {
        return Enum.valueOf(ScreenDeviceRefreshRateHelper.class, name);
    }

    public static int getHighestRefreshRate() {
        int highestRefreshRate = 60;
        try {
            GraphicsDevice[] screenDevices;
            GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (localGraphicsEnvironment != null && (screenDevices = localGraphicsEnvironment.getScreenDevices()) != null) {
                for (GraphicsDevice screenDevice : screenDevices) {
                    int refreshRate;
                    DisplayMode displayMode;
                    if (screenDevice == null || (displayMode = screenDevice.getDisplayMode()) == null || (refreshRate = displayMode.getRefreshRate()) <= highestRefreshRate) continue;
                    highestRefreshRate = refreshRate;
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve highest refresh rate", e);
        }
        return highestRefreshRate;
    }

    private static /* synthetic */ ScreenDeviceRefreshRateHelper[] $values() {
        return new ScreenDeviceRefreshRateHelper[0];
    }

    static {
        $VALUES = ScreenDeviceRefreshRateHelper.$values();
        logger = LoggerFactory.getLogger(ScreenDeviceRefreshRateHelper.class);
    }
}

